%Position range:99 or 1-10
%When the position is set to 99, the MBC will track the point near half output power.
%When the position is set to 1-10, the MBC will track the 1st to 10th point in the range from zero to maximum output voltage.
function [status] = SetTrackingPosition(Position) 
global s;
if(s.BytesAvailable ~= 0)
    fread(s,s.BytesAvailable);
end
byteID=159;
byteData=[Position 0 0 0 0 0];
fwrite(s,[byteID byteData]);
dataRec = fread(s,9);
returnedByteID = dataRec(1,1);
if(returnedByteID ~= byteID)
    status = 102;
    disp('Unknown Error. Please try again')
    return;
end
status = dataRec(2,1);
end